init_sprites:
    ld      de, $3800
    ld      hl, SprPatterns
    ld      bc, $800
    call    $1fdf       ; WRITE VRAM
    ld      a, 0
    call    $1fc1       ; INIT_SPR_ORDER
    ld      a, 0
    call    $1fc4
    ld      a,$d0  
    out     ($be), a
    ret

show_dan1_sprites:
    ld      hl, SprAttrib_DAN1
    jr      show_sprites

show_bitbuster_sprites:
    ld      hl, SprAttrib_BITBUSTER
    jr      show_sprites

show_zx0_sprites:
    ld      hl, SprAttrib_ZX0
    jr      show_sprites

show_zx7_sprites:
    ld      hl, SprAttrib_ZX7
    jr      show_sprites

show_pletter_sprites:
    ld      hl, SprAttrib_PLETTER
    jr      show_sprites

show_dan3_sprites:
    ld      hl, SprAttrib_DAN3
    jr      show_sprites

show_lzf_sprites:
    ld      hl, SprAttrib_LZF
    jr      show_sprites

show_mdkrle_sprites:
    ld      hl, SprAttrib_MDKRLE

show_sprites:
    ld      de, ($8002)
    ld      bc, 16
    ldir
    ld      a, 4
    call    $1fc1       ; INIT_SPR_ORDER
    ld      a, 4
    call    $1fc4
    ld      a,$d0  
    out     ($be), a
    ret

SprAttrib_ZX0:
    db     0, 192, $00, 6
    db     0, 208, $04, 6
    db     0, 224, $08, 6
    db     0, 240, $0C, 6

SprAttrib_DAN3:
    db     0, 192, $10, 6
    db     0, 208, $14, 6
    db     0, 224, $18, 6
    db     0, 240, $1C, 6

SprAttrib_DAN1:
    db     0, 192, $20, 6
    db     0, 208, $24, 6
    db     0, 224, $28, 6
    db     0, 240, $2C, 6

SprAttrib_ZX7:
    db     0, 192, $30, 6
    db     0, 208, $34, 6
    db     0, 224, $38, 6
    db     0, 240, $3C, 6

SprAttrib_PLETTER:
    db     0, 192, $40, 6
    db     0, 208, $44, 6
    db     0, 224, $48, 6
    db     0, 240, $4C, 6

SprAttrib_BITBUSTER:
    db     0, 192, $50, 6
    db     0, 208, $54, 6
    db     0, 224, $58, 6
    db     0, 240, $5C, 6

SprAttrib_LZF:
    db     0, 192, $60, 6
    db     0, 208, $64, 6
    db     0, 224, $68, 6
    db     0, 240, $6C, 6

SprAttrib_MDKRLE:
    db     0, 192, $70, 6
    db     0, 208, $74, 6
    db     0, 224, $78, 6
    db     0, 240, $7C, 6

SprPatterns:
; Line 0: "ZX0 2458+391=2849"
; 64x16 strip - row-major tiles - line00
; -- Sprite 0 (x=0..15)
db $00, $F4, $12, $21, $42, $84, $F4, $00, $00, $61, $12, $24, $47, $80, $70, $00
db $00, $98, $A4, $24, $A4, $A4, $98, $00, $00, $3C, $A1, $B8, $85, $85, $B8, $00
; -- Sprite 1 (x=16..31)
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $C0, $22, $C7, $22, $20, $C0, $00
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $31, $0A, $12, $09, $48, $31, $00
; -- Sprite 2 (x=32..47)
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $84, $44, $44, $C4, $44, $84, $00
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $03, $70, $01, $72, $04, $03, $00
; -- Sprite 3 (x=48..63)
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $18, $A4, $19, $25, $24, $98, $00
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $46, $A9, $29, $E7, $21, $26, $00

; Line 1: "DAN3 2500+391=2891"
; 64x16 strip - row-major tiles - line01
; -- Sprite 0 (x=0..15)
db $00, $E3, $94, $94, $97, $94, $E4, $00, $00, $67, $14, $27, $40, $80, $77, $00
db $00, $24, $B4, $AC, $A4, $A5, $A4, $00, $00, $98, $25, $25, $A5, $A5, $18, $00
; -- Sprite 1 (x=16..31)
db $00, $C0, $20, $40, $20, $20, $C0, $00, $00, $C0, $22, $27, $22, $20, $C0, $00
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $31, $0A, $12, $09, $48, $31, $00
; -- Sprite 2 (x=32..47)
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $84, $44, $44, $C4, $44, $84, $00
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $03, $70, $01, $72, $04, $03, $00
; -- Sprite 3 (x=48..63)
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $18, $A5, $19, $24, $24, $98, $00
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $C2, $22, $22, $E2, $22, $C2, $00

; Line 2: "DAN1 2504+399=2903"
; 64x16 strip - row-major tiles - line02
; -- Sprite 0 (x=0..15)
db $00, $E3, $94, $94, $97, $94, $E4, $00, $00, $67, $14, $27, $40, $80, $77, $00
db $00, $24, $B4, $AC, $A4, $A4, $A4, $00, $00, $98, $24, $25, $A5, $A4, $18, $00
; -- Sprite 1 (x=16..31)
db $00, $40, $40, $40, $40, $40, $40, $00, $00, $40, $A2, $27, $E2, $20, $20, $00
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $31, $0A, $12, $09, $48, $31, $00
; -- Sprite 2 (x=32..47)
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $8C, $52, $52, $CE, $42, $8C, $00
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $03, $70, $01, $72, $04, $03, $00
; -- Sprite 3 (x=48..63)
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $18, $A5, $25, $1D, $05, $98, $00
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $C6, $21, $22, $21, $29, $C6, $00

; Line 3: "ZX7 2569+415=2984"
; 64x16 strip - row-major tiles - line03
; -- Sprite 0 (x=0..15)
db $00, $F4, $12, $21, $42, $84, $F4, $00, $00, $67, $14, $27, $40, $80, $77, $00
db $00, $BC, $84, $08, $90, $90, $90, $00, $00, $9C, $21, $39, $A4, $A4, $18, $00
; -- Sprite 1 (x=16..31)
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $C0, $22, $27, $E2, $20, $C0, $00
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $10, $28, $48, $78, $08, $08, $00
; -- Sprite 2 (x=32..47)
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $9E, $90, $9C, $82, $82, $9C, $00
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $03, $70, $01, $72, $04, $03, $00
; -- Sprite 3 (x=48..63)
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $18, $A5, $24, $1D, $05, $98, $00
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $C2, $25, $C9, $2F, $21, $C1, $00

; Line 4: "Pletter 2572+416=2988"
; 64x16 strip - row-major tiles - line04
; -- Sprite 0 (x=0..15)
db $00, $E4, $94, $94, $E4, $84, $87, $00, $00, $67, $14, $27, $40, $80, $77, $00
db $00, $3D, $20, $38, $20, $20, $BC, $00, $00, $BC, $04, $08, $90, $91, $10, $00
; -- Sprite 1 (x=16..31)
db $00, $EF, $42, $42, $42, $42, $42, $00, $00, $C0, $22, $47, $82, $00, $E0, $00
db $00, $7B, $42, $72, $43, $42, $7A, $00, $00, $10, $28, $48, $78, $08, $08, $00
; -- Sprite 2 (x=32..47)
db $00, $80, $40, $40, $80, $80, $40, $00, $00, $8E, $90, $9C, $92, $92, $8C, $00
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $03, $70, $01, $72, $04, $03, $00
; -- Sprite 3 (x=48..63)
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $18, $A5, $24, $1D, $05, $98, $00
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $C6, $29, $C6, $29, $29, $C6, $00

; Line 5: "BitBuster 2579+423=3002"
; 64x16 strip - row-major tiles - line05
; -- Sprite 0 (x=0..15)
db $00, $E7, $91, $E1, $91, $91, $E7, $00, $00, $67, $14, $27, $40, $80, $77, $00
db $00, $BD, $09, $09, $09, $09, $89, $00, $00, $BC, $05, $09, $90, $90, $10, $00
; -- Sprite 1 (x=16..31)
db $00, $C9, $29, $C9, $29, $29, $C6, $00, $00, $C0, $22, $27, $E2, $20, $C0, $00
db $00, $3B, $40, $30, $08, $08, $70, $00, $00, $11, $28, $48, $79, $0A, $09, $00
; -- Sprite 2 (x=32..47)
db $00, $DE, $90, $9C, $90, $90, $9E, $00, $00, $8C, $42, $84, $02, $12, $CC, $00
db $00, $E0, $90, $90, $E0, $A0, $90, $00, $00, $03, $70, $01, $70, $04, $03, $00
; -- Sprite 3 (x=48..63)
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $18, $A5, $25, $A5, $A5, $18, $00
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $C6, $21, $22, $24, $28, $C7, $00

; Line 6: "LZF 2749+446=3195"
; 64x16 strip - row-major tiles - line06
; -- Sprite 0 (x=0..15)
db $00, $87, $80, $81, $82, $84, $F7, $00, $00, $67, $10, $21, $42, $82, $72, $00
db $00, $BC, $A0, $38, $20, $20, $A0, $00, $00, $88, $95, $25, $3C, $04, $04, $00
; -- Sprite 1 (x=16..31)
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $C0, $22, $27, $E2, $20, $C0, $00
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $10, $29, $4A, $7B, $08, $08, $00
; -- Sprite 2 (x=32..47)
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $8E, $50, $5C, $D2, $52, $4C, $00
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $03, $70, $01, $70, $04, $03, $00
; -- Sprite 3 (x=48..63)
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $08, $89, $09, $88, $88, $08, $00
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $CF, $28, $2E, $E1, $21, $CE, $00

; Line 7: "RLE 2981+706=3687"
; 64x16 strip - row-major tiles - line07
; -- Sprite 0 (x=0..15)
db $00, $E4, $94, $94, $E4, $A4, $97, $00, $00, $63, $14, $24, $43, $80, $73, $00
db $00, $3C, $20, $38, $20, $20, $BC, $00, $00, $18, $A4, $98, $A4, $A4, $18, $00
; -- Sprite 1 (x=16..31)
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $40, $42, $47, $42, $40, $40, $00
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $79, $0A, $12, $22, $22, $21, $00
; -- Sprite 2 (x=32..47)
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $8E, $50, $5C, $52, $52, $8C, $00
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $03, $70, $01, $70, $04, $03, $00
; -- Sprite 3 (x=48..63)
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $1C, $A1, $38, $A5, $A5, $18, $00
db $00, $00, $00, $00, $00, $00, $00, $00, $00, $CF, $21, $C2, $24, $24, $C4, $00
